import { jsx } from "react/jsx-runtime";
import { createContext, useContext, useMemo } from "react";
import { DefaultBackground } from "../components/default-components/DefaultBackground.mjs";
import { DefaultBrush } from "../components/default-components/DefaultBrush.mjs";
import {
  DefaultCanvas
} from "../components/default-components/DefaultCanvas.mjs";
import {
  DefaultCollaboratorHint
} from "../components/default-components/DefaultCollaboratorHint.mjs";
import { DefaultCursor } from "../components/default-components/DefaultCursor.mjs";
import {
  DefaultErrorFallback
} from "../components/default-components/DefaultErrorFallback.mjs";
import { DefaultGrid } from "../components/default-components/DefaultGrid.mjs";
import { DefaultHandle } from "../components/default-components/DefaultHandle.mjs";
import { DefaultHandles } from "../components/default-components/DefaultHandles.mjs";
import { DefaultLoadingScreen } from "../components/default-components/DefaultLoadingScreen.mjs";
import { DefaultScribble } from "../components/default-components/DefaultScribble.mjs";
import {
  DefaultSelectionBackground
} from "../components/default-components/DefaultSelectionBackground.mjs";
import {
  DefaultSelectionForeground
} from "../components/default-components/DefaultSelectionForeground.mjs";
import {
  DefaultShapeErrorFallback
} from "../components/default-components/DefaultShapeErrorFallback.mjs";
import {
  DefaultShapeIndicator
} from "../components/default-components/DefaultShapeIndicator.mjs";
import {
  DefaultShapeIndicatorErrorFallback
} from "../components/default-components/DefaultShapeIndicatorErrorFallback.mjs";
import { DefaultShapeIndicators } from "../components/default-components/DefaultShapeIndicators.mjs";
import {
  DefaultSnapIndicator
} from "../components/default-components/DefaultSnapIndictor.mjs";
import { DefaultSpinner } from "../components/default-components/DefaultSpinner.mjs";
import { DefaultSvgDefs } from "../components/default-components/DefaultSvgDefs.mjs";
import { useShallowObjectIdentity } from "./useIdentity.mjs";
const EditorComponentsContext = createContext(null);
function EditorComponentsProvider({
  overrides = {},
  children
}) {
  const _overrides = useShallowObjectIdentity(overrides);
  const value = useMemo(
    () => ({
      Background: DefaultBackground,
      SvgDefs: DefaultSvgDefs,
      Brush: DefaultBrush,
      ZoomBrush: DefaultBrush,
      CollaboratorBrush: DefaultBrush,
      Cursor: DefaultCursor,
      CollaboratorCursor: DefaultCursor,
      CollaboratorHint: DefaultCollaboratorHint,
      CollaboratorShapeIndicator: DefaultShapeIndicator,
      Grid: DefaultGrid,
      Scribble: DefaultScribble,
      SnapIndicator: DefaultSnapIndicator,
      Handles: DefaultHandles,
      Handle: DefaultHandle,
      CollaboratorScribble: DefaultScribble,
      ErrorFallback: DefaultErrorFallback,
      ShapeErrorFallback: DefaultShapeErrorFallback,
      ShapeIndicatorErrorFallback: DefaultShapeIndicatorErrorFallback,
      Spinner: DefaultSpinner,
      SelectionBackground: DefaultSelectionBackground,
      SelectionForeground: DefaultSelectionForeground,
      ShapeIndicators: DefaultShapeIndicators,
      ShapeIndicator: DefaultShapeIndicator,
      OnTheCanvas: null,
      InFrontOfTheCanvas: null,
      Canvas: DefaultCanvas,
      LoadingScreen: DefaultLoadingScreen,
      ..._overrides
    }),
    [_overrides]
  );
  return /* @__PURE__ */ jsx(EditorComponentsContext.Provider, { value, children });
}
function useEditorComponents() {
  const components = useContext(EditorComponentsContext);
  if (!components) {
    throw new Error("useEditorComponents must be used inside of <EditorComponentsProvider />");
  }
  return components;
}
export {
  EditorComponentsProvider,
  useEditorComponents
};
//# sourceMappingURL=useEditorComponents.mjs.map
